#!/bin/bash
#
# Licence:    Open source / public domain
# Author:     Enkidu

if test -z "$1" ; then
	echo "Usage: show-records.sh [records-only|ro] <logfile>"
	exit 2
fi

EXIT_RO='false'
if test "$1" == 'records-only' || test "$1" == 'ro' ; then
	EXIT_RO='true'
	shift 1
fi

if ! test -e "$1" ; then
	echo "Logfile $1 not found"
	exit 2
fi


if $EXIT_RO ; then
	cat "$1" | sed -e "/^N=.*\\*/!d"
	exit 1
fi

cat "$1" | sed -e "/^Now at/ d"

echo
echo "The last 5 lines of the log file are:"
cat "$1" | sed -e '/^Now at/ !d' | tail -n 5 -

echo
echo "The 5 slowest calculations were:"
cat "$1" | sed -e '/^Now at/!d' | sort -k 4.2 | tail -n 5
echo

echo "Maximum use of gmp was:"
cat "$1" | sed -e '/^Now at/!d' | sort -n -k 11 | tail -n 5
exit 0
