#!/bin/bash

if test -z "$1" ; then
	echo "Usage: gmp-used.sh <logfile>"
	exit 2
fi

if ! test -e "$1" ; then
	echo "File $1 not found"
	exit 2
fi

GMP_USED=$(cat "$1" | sed -e '/^Now at/!d; s/^Now at.*used //; s/ times//' | sort -nu)

echo "$GMP_USED"
echo
exit 0
