#!/bin/bash
#
# Show records from all logfiles

FIRSTFILE='0'
LASTFILE=$(ls -1 collatz-*.log | tail -n 1 | sed -e "s/^collatz-//; s/T.*//")

for NUMBER in $(seq 0 $LASTFILE) ; do

	NUMBERTO=$(($NUMBER + 1))

	if test $(($NUMBER)) -lt $((10)) ; then
		NUMBER="0$NUMBER"
	fi

	if test $(($NUMBERTO)) -lt $((10)) ; then
		NUMBERTO="0$NUMBERTO"
	fi

	#echo $NUMBER $NUMBERTO
	if ! test -r collatz-${NUMBER}T-${NUMBERTO}T.log ; then
		echo "File collatz-${NUMBER}T-${NUMBERTO}T.log not found"
		continue
	fi

	if test "$1" = 'steps' ; then
		cat collatz-${NUMBER}T-${NUMBERTO}T.log | sed -e "/^N=.*\*/!d; /\*STEPS=/!d"
	elif test "$1" = 'max' ; then
		cat collatz-${NUMBER}T-${NUMBERTO}T.log | sed -e "/^N=.*\*/!d; /\*MAX=/!d"
		cat collatz-${NUMBER}T-${NUMBERTO}T.log \
			| sed -e "/^Max value reached/!d; s/in this batch/in ${NUMBER}T-${NUMBERTO}T/"
	else
		cat collatz-${NUMBER}T-${NUMBERTO}T.log | sed -e "/^N=.*\*/!d"
	fi
done
